//
//  FinalSendViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 30.05.22.
//

import UIKit
import Firebase

class FinalSendViewController: UIViewController {
    
    
    @IBOutlet var headerTextLabel: UILabel!
    
    @IBOutlet weak var verificationLabel: UILabel!
    
    @IBOutlet var checkmarkImageView: UIImageView!
    
    @IBOutlet var transactionAmountLabel: UILabel!

    @IBOutlet var transactionRecipient: UILabel!
    
    @IBOutlet var transactionInformationTextLabel: UILabel!
    @IBOutlet var continueButton: UIButton!
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        headerTextLabel.font = Fonts.mediumFontWithSize(size: 20)
        
        checkmarkImageView.translatesAutoresizingMaskIntoConstraints = false
        checkmarkImageView.centerXAnchor.constraint(equalTo: view.centerXAnchor).isActive = true

        continueButton.titleLabel?.font = Fonts.mediumFontWithSize(size: 17)
        Utilities.styleFilledButtonAuthScreenGreenEdged(continueButton)
        
        
        
        transactionAmountLabel.numberOfLines = 0
        transactionAmountLabel.lineBreakMode = .byTruncatingTail
        transactionAmountLabel.font = Fonts.heavyFontWithSize(size: 27)
        
        var transactionAmountSubString = transactionAmountPublic

        let transactionAmountString = NSMutableAttributedString.init(string: "Sie haben "+transactionAmountSubString)
        transactionAmountString.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 21),
                                    NSAttributedString.Key.foregroundColor: UIColor(red: 55.0/255.0, green: 85.0/255.0, blue: 135.0/255.0, alpha: 1.0)],
                                                     range: NSMakeRange(0, 9))
        transactionAmountLabel.attributedText = transactionAmountString
        
        
        
        transactionRecipient.numberOfLines = 0
        transactionRecipient.lineBreakMode = .byTruncatingTail
        transactionRecipient.font = Fonts.heavyFontWithSize(size: 24)

        let transactionRecpipientString = NSMutableAttributedString.init(string: "an " + transactionRecipientPublic)
        transactionRecpipientString.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 21),
                                                   NSAttributedString.Key.foregroundColor: UIColor(red: 55.0/255.0, green: 85.0/255.0, blue: 135.0/255.0, alpha: 1.0)],
                                                     range: NSMakeRange(0, 2))
        transactionRecipient.attributedText = transactionRecpipientString
        
        transactionInformationTextLabel.text = "gesendet."
        transactionInformationTextLabel.font = Fonts.mediumFontWithSize(size: 21)
        
        
        // Do any additional setup after loading the view.
        showVerificationCode()

        
        let seconds = 1.0 // 0.8
        DispatchQueue.main.asyncAfter(deadline: .now() + seconds) {
            // Put your code which should be executed with a delay here
             
            // ignore alert if we used the developer PIN
            if appPINPublic != developerAppPINPublic {
                self.appVersionAlert()
            }
        }
    }
    
    func resetPublicVariables() {
        backFromBackButtonOrSummaryViewController = false
        returnedFromTransactionSummaryView = false
        
        transactionRecipientPublic = ""
        transactionIBANPublic = ""
        transactionAmountPublic = ""
        transactionPurposePublic = ""
        
        transactionTypoIBANPublic = []
    }
    
    // https://zeglaty.medium.com/alert-with-custom-font-73671585cc0e
    func appVersionAlert() {
        
        
        let alert = UIAlertController(title: validationCodePublic, message: "\nUm mit der Umfrage fortzufahren, geben Sie diesen 4-stelligen Validierungs-Code in der Qualtrics-Umfrage an Ihrem PC/Laptop ein.", preferredStyle: .alert)
        alert.setTitlet(font: UIFont(name: "Avenir-Medium", size: 35), color: Colors.carmine)
        alert.setMessage(font: UIFont(name: "Avenir-Medium", size: 14), color: Colors.greyColor)
                            
        
        
        alert.addAction(UIAlertAction(title: "Verstanden", style: .cancel, handler: { (action: UIAlertAction!) in
              print("Handle Cancel Logic here")
            
        }))
        // Ändere die Textfarbe der Aktion "Umfrage fortsetzen" auf Rot
        if let continueAction = alert.actions.first(where: { $0.title == "Verstanden" }) {
            continueAction.setValue(Colors.carmine, forKey: "titleTextColor")
        }
        
        
        

                    
                    present(alert , animated: true , completion: nil)
        
       
    }
    
    func showVerificationCode() {
        
        verificationLabel.text = validationCodePublic
        
    }
    
    @IBAction func continueButton(_ sender: Any) {
        resetPublicVariables()
        
      
        
        let tbc = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
        
        tbc.modalPresentationStyle = .fullScreen
        tbc.modalTransitionStyle = .crossDissolve
        present(tbc, animated: true)
         
    }
    
    

}

// alert extension
extension UIAlertController {
    
    //Set background color of UIAlertController
    func setBackgroundColor(color: UIColor) {
        if let bgView = self.view.subviews.first, let groupView = bgView.subviews.first, let contentView = groupView.subviews.first {
            contentView.backgroundColor = color
        }
    }
    
    //Set title font and title color
    func setTitlet(font: UIFont?, color: UIColor?) {
        guard let title = self.title else { return }

        let attributeString = NSMutableAttributedString(string: title)//1
        let range = NSRange(location: 0, length: (title as NSString).length)
        
        if let titleFont = font {
            attributeString.addAttributes([NSAttributedString.Key.font : titleFont],//2
                                          range: range)
        }
        
        if let titleColor = color {
            attributeString.addAttributes([NSAttributedString.Key.foregroundColor : titleColor],//3
                                          range: range)
        }
        self.setValue(attributeString, forKey: "attributedTitle")//4
    }
    
    //Set message font and message color
    func setMessage(font: UIFont?, color: UIColor?) {
        guard  let message = self.message else { return }
        
        let attributeString = NSMutableAttributedString(string: message)
        let range = NSRange(location: 0, length: (message as NSString).length)
        
        if let messageFont = font {
            attributeString.addAttributes([NSAttributedString.Key.font : messageFont],
                                          range: range)
        }
        
        if let messageColorColor = color {
            attributeString.addAttributes([NSAttributedString.Key.foregroundColor : messageColorColor],
                                          range: range)
        }
        self.setValue(attributeString, forKey: "attributedMessage")
    }
    
    //Set tint color of UIAlertController
    func setTint(color: UIColor) {
        self.view.tintColor = color
    }
}

extension UIImageView {
    func applyshadowWithCorner(containerView : UIView, cornerRadious : CGFloat){
        containerView.clipsToBounds = false
        containerView.layer.shadowColor = UIColor.black.cgColor
        containerView.layer.shadowOpacity = 1
        containerView.layer.shadowOffset = CGSize.zero
        containerView.layer.shadowRadius = 10
        containerView.layer.cornerRadius = cornerRadious
        containerView.layer.shadowPath = UIBezierPath(roundedRect: containerView.bounds, cornerRadius: cornerRadious).cgPath
        self.clipsToBounds = true
        self.layer.cornerRadius = cornerRadious
    }
}
